	clear all
	%	Compare filters
	% Fig. 7.8 Tg
	clear all
	
	Wc = 20000;
	Ws = 28000;
	Amax = 0.28029;
	Amin = 40;
	lw = 2; fs = 16;
	fn = 'times'; 
	subplot('position', [0.08 0.4 0.90 0.5]);

%	axis([0, 50000, 0, 12]);
	W = [0:20:50000];
	N = 18;
	[G, Z, R_ZEROS, P, Wsnew] = BW_POLES_S(Wc, Ws, Amax, Amin, N);
	Tg = PZ_2_TG_S(G, Z, P, W);
	plot(W, Tg,'linewidth',lw);
	hold on
	
	N = 8;
	[G, Z, R_ZEROS, P, Wsnew]= CH_I_POLES_S(Wc, Ws, Amax, Amin, N);
	Tg = PZ_2_TG_S(G, Z, P, W);
	plot(W, Tg,'linewidth',lw);
	
	[G, Z, R_ZEROS, P, Wsnew] = CH_II_POLES_S(Wc, Ws, Amax, Amin, N);
	Tg = PZ_2_TG_S(G, Z, P, W);
	plot(W, Tg,'linewidth',lw);
	
	N = 5;
	[G, Z, R_ZEROS, P, Wsnew] = CA_POLES_S(Wc, Ws, Amax, Amin, N);
	Tg = PZ_2_TG_S(G, Z, P, W);
	plot(W, Tg,'linewidth',lw);
	
	grid on	
	set(gca,'FontName', fn,'FontSize', fs);
	xlabel('\omega   [rad/s]','FontName','times','FontSize',fs);
	ylabel('        \tau_g(\omega)   [s]','FontName', fn,'FontSize',fs);
